/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.tatssense.core.Buckstracks;
import com.tatssense.core.bean.LinkerBean;
import com.tatssense.core.bean.MultiEventBean;
import com.tatssense.core.configuration.ManageAdvesrtiserId;
import com.tatssense.core.configuration.ManageLink_v2;
import com.tatssense.core.configuration.ManageUserAgent;
import com.tatssense.core.gcm.GcmIntentService;
import com.tatssense.core.model.Events;
import com.tatssense.core.model.ManageEvent;
import com.tatssense.core.util.BucksLog;
import com.tatssense.core.util.BuildBuckstracks;
import com.tatssense.core.util.UtilsBucksTracks;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

class AppTracker {
    public static final String VERSION = BuildBuckstracks.VERSION;
    public static final int VERSION_CODE = BuildBuckstracks.VERSION_CODE;
    public static ENVIROMENT_OPT ENVIROMENT = ENVIROMENT_OPT.PRODUCTION;
    protected Context context;
    protected String advertiserId;
    protected ConcurrentHashMap<?, ?> paramTable;
    boolean initialized;
    protected String install;
    protected String link = null;
    protected List<String> paramList;
    static AppTracker instance;

    public AppTracker(Context context, String advertiserId) {
        this.initAppTracker(context, advertiserId, null, null);
    }

    public AppTracker(Activity activity, String advertiserId) {
        ManageUserAgent.createUserAgent(activity.getApplicationContext());
        ManageAdvesrtiserId.createAdvertiserId(activity.getApplicationContext());
        this.initAppTracker(activity.getApplicationContext(), advertiserId, null, null);
    }

    public AppTracker(Activity activity) {
        this(activity, UtilsBucksTracks.getMetadataAppId((Context)activity), UtilsBucksTracks.getMetadataGcmProjectNumb((Context)activity));
    }

    public AppTracker(Activity activity, String advertiserId, String gcmSenderId) {
        ManageUserAgent.createUserAgent(activity.getApplicationContext());
        ManageAdvesrtiserId.createAdvertiserId(activity.getApplicationContext());
        this.initAppTracker(activity.getApplicationContext(), advertiserId, null, gcmSenderId);
    }

    public AppTracker(Context context, String advertiserId, String gcmId) {
        this.initAppTracker(context, advertiserId, null, gcmId);
    }

    public AppTracker(Context context) {
        this(context, UtilsBucksTracks.getMetadataAppId(context), UtilsBucksTracks.getMetadataGcmProjectNumb(context));
    }

    public void allowMultiple(boolean allow) {
        UtilsBucksTracks.saveBooleanInSP(this.context, "key_allow_multiple", allow);
    }

    protected void initAppTracker(Context context, String advertiserId, String gcmId, String gcmSenderId) {
        if (gcmId != null) {
            UtilsBucksTracks.saveStringInSP(context, "key_gcm", gcmId);
        }
        this.configureMetaData(context);
        this.context = context;
        this.advertiserId = advertiserId;
        UtilsBucksTracks.saveStringInSP(context, "key_advertise_id", advertiserId);
        UtilsBucksTracks.saveGPSData(context);
        this.sendStoredCalls(context);
        this.trackInstall();
        this.enableGcmNotify(gcmSenderId);
        this.testReferrer();
    }

    private void configureMetaData(Context context) {
        Locale current = context.getResources().getConfiguration().locale;
        try {
            BucksLog.LOG_TYPE = BucksLog.LEVEL.valueOf(UtilsBucksTracks.getMetadataLogLevel(context).toUpperCase(current));
        }
        catch (Exception e) {
            BucksLog.e(Buckstracks.class.getCanonicalName(), "Error during parse log-type meta-data field on you AndroidManifest.xml");
        }
        try {
            ENVIROMENT = ENVIROMENT_OPT.valueOf(UtilsBucksTracks.getMetadataEnviroment(context).toUpperCase(current));
            BucksLog.i(Buckstracks.class.getCanonicalName(), "LOG_TYPE[" + (Object)((Object)BucksLog.LOG_TYPE) + "] ENVIROMENT[" + (Object)((Object)ENVIROMENT) + "]");
        }
        catch (Exception e) {
            BucksLog.e(Buckstracks.class.getCanonicalName(), "Error during parse enviroment meta-data field on you AndroidManifest.xml");
        }
    }

    private void enableGcmNotify(String gcmSenderId) {
        if (gcmSenderId != null && !gcmSenderId.isEmpty()) {
            UtilsBucksTracks.saveStringInSP(this.context, "SENDER_ID_GCM", gcmSenderId);
            new GcmTask(this.context).execute(new Void[0]);
        }
    }

    private void testReferrer() {
        SharedPreferences sp = this.context.getSharedPreferences("mat_referrer", 0);
    }

    public void trackRefererrer() {
        BucksLog.d(this.getClass().getName(), "Track install Broadcast");
        this.track("8", "REFERRER_RECEIVE");
    }

    public void trackRefererrer2() {
        BucksLog.d(this.getClass().getName(), "Track install Broadcast");
        this.track("8", "REFERRER_RECEIVE_2");
    }

    public void trackInstall() {
        BucksLog.d(this.getClass().getName(), "Track install");
        this.trackInstall(this.context);
    }

    protected synchronized void trackInstall(Context context) {
        this.install = UtilsBucksTracks.getStringFromSP(context, "install");
        BucksLog.d(this.getClass().getName(), "trackInstall install[" + this.install + "]");
        if (!this.install.equals("")) {
            String savedVersion = UtilsBucksTracks.getStringFromSP(context, "version");
            BucksLog.d(this.getClass().getName(), "trackInstall Update savedVersion[" + savedVersion + "] currentVersion[" + UtilsBucksTracks.getAppVersion(context) + "]");
            if (savedVersion.length() != 0 && !savedVersion.equals(UtilsBucksTracks.getAppVersion(context))) {
                AppTracker.eventActionContext("2", "UPDATE", context);
                UtilsBucksTracks.saveStringInSP(context, "version", UtilsBucksTracks.getAppVersion(context));
                BucksLog.d(this.getClass().getName(), "trackInstall Update new saved Version[" + UtilsBucksTracks.getAppVersion(context) + "]");
            }
        } else {
            BucksLog.d(this.getClass().getName(), "trackInstall First Install");
            UtilsBucksTracks.saveStringInSP(context, "install", "installed");
            UtilsBucksTracks.saveStringInSP(context, "version", UtilsBucksTracks.getAppVersion(context));
            AppTracker.eventActionContext("1", "INSTALL", context);
        }
    }

    public void trackOpen() {
        this.track("3", "OPEN");
    }

    public static void trackOpen(Context context) {
        if (instance == null) {
            instance = new AppTracker(context);
        }
        instance.trackOpen();
    }

    public void trackClose() {
        this.track("4", "CLOSE");
    }

    public void trackUpdate() {
        this.track("2", "UPDATE");
    }

    public void trackSubscription() {
        this.track("5", "SUBSCRIPTION");
    }

    public void trackGcm() {
        this.track("9", "GCM");
    }

    public void trackUserId() {
        this.track("10", "USER_ID");
    }

    public void trackAdvertiseId() {
        this.track("12", "ANDROID_ADVID");
    }

    public void trackCustomEvent(String paramId) {
        this.track(paramId, "EVENT");
    }

    public void eventTracker(String actionId, String action) {
        this.track(actionId, action);
    }

    private synchronized void track(String actionId, String action) {
        if (UtilsBucksTracks.isOnline(this.context)) {
            LinkerBean linker = new LinkerBean(this.context, action, actionId);
            new Thread(new ManageLink_v2(this.context, linker, true)).start();
        }
    }

    private synchronized void trackStoredCalls(Events events) {
        if (UtilsBucksTracks.isOnline(this.context)) {
            new Thread(new ManageLink_v2(this.context, events, false)).start();
        }
    }

    protected void sendStoredCalls(Context context) {
        List<Events> listaEvent = ManageEvent.getInstance(context).loadAll();
        for (Events events : listaEvent) {
            this.trackStoredCalls(events);
        }
    }

    boolean checkPlayServices(Context context) {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        return resultCode == 0;
    }

    static void eventActionContext(String actionId, String action, Context context) {
        Intent i = new Intent("com.google.android.c2dm.intent.RECEIVE");
        i.putExtra(GcmIntentService.TRACK_ACTION_KEY, (Serializable)new MultiEventBean(actionId, action));
        i.addCategory(context.getPackageName());
        context.sendBroadcast(i);
    }

    static void eventActionContext(MultiEventBean multiEventBean, Context context) {
        Intent i = new Intent("com.google.android.c2dm.intent.RECEIVE");
        i.putExtra(GcmIntentService.TRACK_ACTION_KEY, (Serializable)multiEventBean);
        i.addCategory(context.getPackageName());
        context.sendBroadcast(i);
    }

    static void eventCustomActionContext(String actionId, String customValue, Context context) {
        MultiEventBean multiEventBean = new MultiEventBean(actionId, "EVENT").addKeyValue("ts131", customValue);
        AppTracker.eventActionContext(multiEventBean, context);
    }

    static void eventPurchaseActionContext(String currencyCode, String price, Context context) {
        MultiEventBean multiEventBean = new MultiEventBean("42", "PURCHASE").addKeyValue("ts131", price).addKeyValue("ts82", currencyCode);
        AppTracker.eventActionContext(multiEventBean, context);
    }

    static void eventPurchaseActionContext(String currencyCode, String price, Activity activity) {
        MultiEventBean multiEventBean = new MultiEventBean("42", "PURCHASE").addKeyValue("ts131", price).addKeyValue("ts82", currencyCode);
        AppTracker.eventActionActivity(multiEventBean, activity);
    }

    static void eventClickNotificationActionContext(String campainParameter, Context context) {
        MultiEventBean multiEventBean = new MultiEventBean("43", "NOTIFICATION_CLICK").addKeyValue("ts132", campainParameter);
        AppTracker.eventActionContext(multiEventBean, context);
    }

    static void eventClickNotificationActionActivity(String campainParameter, Activity activity) {
        MultiEventBean multiEventBean = new MultiEventBean("43", "NOTIFICATION_CLICK").addKeyValue("ts132", campainParameter);
        AppTracker.eventActionActivity(multiEventBean, activity);
    }

    static void eventActionActivity(String actionId, String action, Activity activity) {
        AppTracker.eventActionContext(actionId, action, activity.getApplicationContext());
    }

    static void eventActionActivity(MultiEventBean multiEventBean, Activity activity) {
        AppTracker.eventActionContext(multiEventBean, activity.getApplicationContext());
    }

    public class GcmTask
    extends AsyncTask<Void, Void, String> {
        Context context;

        public GcmTask(Context context) {
            this.context = context;
        }

        protected String doInBackground(Void ... params) {
            String res = null;
            try {
                GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)this.context);
                res = gcm.register(new String[]{UtilsBucksTracks.getStringFromSP(this.context, "SENDER_ID_GCM")});
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return res;
        }

        protected void onPostExecute(String result) {
            if (result != null && !result.isEmpty()) {
                UtilsBucksTracks.saveStringInSP(this.context, "key_gcm", result);
                BucksLog.i(((Object)((Object)this)).getClass().getName(), "action: -> " + UtilsBucksTracks.getStringFromSP(this.context, "key_gcm"));
                AppTracker.this.trackGcm();
            }
            super.onPostExecute((Object)result);
        }
    }

    static enum ENVIROMENT_OPT {
        PRODUCTION,
        SANDBOX;

    }
}

