/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.tatssense.core.bucstracks.beans.Request.CheckScreenReq;
import com.tatssense.core.bucstracks.beans.Request.IBean;
import com.tatssense.core.bucstracks.beans.Response.CheckScreenRes;
import com.tatssense.core.bucstracks.controller.databean.InDataBeanActivityScreen;
import com.tatssense.core.bucstracks.screenclasses.CallbackInt;
import com.tatssense.core.bucstracks.screenclasses.GetScreenThread;
import com.tatssense.core.bucstracks.starter.controller.ActionController;
import com.tatssense.core.bucstracks.starter.controller.ActionIntroNative;
import com.tatssense.core.bucstracks.starter.controller.ActionIntroVideo;
import com.tatssense.core.bucstracks.starter.controller.ActionIntroWeb;
import com.tatssense.core.bucstracks.starter.controller.ActionOverlayNative;
import com.tatssense.core.bucstracks.starter.controller.ActionOverlayWeb;
import com.tatssense.core.bucstracks.starter.controller.ActionSlider;

public abstract class ScreenMaster
implements CallbackInt {
    private static final String TAG = ScreenMaster.class.getSimpleName();
    Activity activity;
    CheckScreenRes checkScreenRes = null;
    ActionController actionController;

    public ScreenMaster(Activity activity, String tag) {
        this.activity = activity;
        new Thread(new GetScreenThread(activity.getApplicationContext(), CheckScreenReq.newInstance((Context)activity, tag), this)).start();
    }

    public ScreenMaster(Activity activity) {
        this.activity = activity;
        new Thread(new GetScreenThread(activity.getApplicationContext(), CheckScreenReq.newInstance((Context)activity), this)).start();
    }

    public ScreenMaster(Activity activity, IBean iBeanRequest) {
        this.activity = activity;
        new Thread(new GetScreenThread(activity.getApplicationContext(), iBeanRequest, this)).start();
    }

    public CheckScreenRes getCheckScreenRes() {
        return this.checkScreenRes;
    }

    public void setCheckScreenRes(CheckScreenRes checkScreenRes) {
        this.checkScreenRes = checkScreenRes;
    }

    @Override
    public void callbackMethod(CheckScreenRes scType) {
        this.checkScreenRes = scType;
        if (scType != null && scType.getError() != null && scType.getError().getCode() == 0 && scType.getResult() != null && scType.getResult().getConfig() != null && scType.getResult().getConfig().getType() != null) {
            String type = scType.getResult().getConfig().getType();
            if (type.equalsIgnoreCase(InDataBeanActivityScreen.TYPE_SCREEN_BEAN.OVERLAY.toString())) {
                String subtype = scType.getResult().getConfig().getOverlay().getSubType();
                if (subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.NATIVE.toString())) {
                    this.actionController = new ActionController(ActionOverlayNative.buildInstance(this.activity, scType));
                } else if (subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.WEB.toString())) {
                    this.actionController = new ActionController(ActionOverlayWeb.buildInstance(this.activity, scType));
                }
            } else if (type.equalsIgnoreCase(InDataBeanActivityScreen.TYPE_SCREEN_BEAN.INTRO.toString())) {
                String subtype = scType.getResult().getConfig().getIntro().getSub_type();
                if (subtype != null && subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.NATIVE.toString())) {
                    this.actionController = new ActionController(ActionIntroNative.buildInstance(this.activity, scType));
                } else if (subtype != null && subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.WEB.toString())) {
                    this.actionController = new ActionController(ActionIntroWeb.buildInstance(this.activity, scType));
                } else if (subtype != null && subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.VIDEO.toString())) {
                    this.actionController = new ActionController(ActionIntroVideo.buildInstance(this.activity, scType));
                }
            } else if (type.equalsIgnoreCase(InDataBeanActivityScreen.TYPE_SCREEN_BEAN.SLIDER.toString())) {
                this.actionController = new ActionController(ActionSlider.buildInstance(this.activity, scType));
            }
            if (this.actionController != null) {
                this.actionController.startAction();
            }
        }
    }

    @Override
    public void responseError(String message, int code) {
        Log.i((String)"", (String)"");
    }
}

