/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.bean;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import com.tatssense.core.bean.GenericBean;
import com.tatssense.core.bean.MultiEventBean;
import com.tatssense.core.util.BucksLog;
import com.tatssense.core.util.BuildBuckstracks;
import com.tatssense.core.util.UtilsBucksTracks;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class LinkerBean
extends GenericBean {
    private static final long serialVersionUID = 1L;
    private static final String TAG = "LinkerBean";
    Context context = null;
    String url = null;
    List<NameValuePair> qparams = null;
    String action = null;
    String actionId = null;
    MultiEventBean multiEvent = null;

    public LinkerBean(Context context, String action, String actionId) {
        this.context = context;
        this.action = action;
        this.actionId = actionId;
    }

    public LinkerBean(Context context, MultiEventBean multiEvent) {
        this.context = context;
        this.action = multiEvent.action;
        this.actionId = multiEvent.actionId;
        this.multiEvent = multiEvent;
    }

    public void addParameter(int key, String value) {
        if (this.qparams != null) {
            this.qparams.add((NameValuePair)new BasicNameValuePair(this.context.getString(key), value));
        }
    }

    private List<NameValuePair> initParameter(Context context, String action, String actionId) {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        qparams.add((NameValuePair)new BasicNameValuePair("ts31", UtilsBucksTracks.getStringFromSP(context, "key_advertise_id")));
        qparams.add((NameValuePair)new BasicNameValuePair("ts45", UtilsBucksTracks.getDeviceId(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts46", Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id")));
        qparams.add((NameValuePair)new BasicNameValuePair("ts47", UtilsBucksTracks.md5Hashing(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"))));
        qparams.add((NameValuePair)new BasicNameValuePair("ts48", UtilsBucksTracks.sha1(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"))));
        qparams.add((NameValuePair)new BasicNameValuePair("ts49", UtilsBucksTracks.getOdin(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts50", UtilsBucksTracks.getMacAddr(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts51", UtilsBucksTracks.getMacAddressl(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts52", UtilsBucksTracks.getMacAddressAlpha(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts53", UtilsBucksTracks.getMacAddressAlphal(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts54", UtilsBucksTracks.getMacAddressSha1(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts55", UtilsBucksTracks.getMacAddressSha1l(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts56", UtilsBucksTracks.getMacAddressMD5(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts57", UtilsBucksTracks.getMacAddressMD5l(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts58", UtilsBucksTracks.getMacAddressAlphalMD5(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts59", UtilsBucksTracks.getMacAddrAlphalSha1(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts60", UtilsBucksTracks.getUnid(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts61", Build.MANUFACTURER));
        qparams.add((NameValuePair)new BasicNameValuePair("ts62", Build.MODEL));
        qparams.add((NameValuePair)new BasicNameValuePair("ts63", UtilsBucksTracks.getCarrier(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts64", Build.VERSION.RELEASE));
        qparams.add((NameValuePair)new BasicNameValuePair("ts65", UtilsBucksTracks.getCountryCode(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts66", this.createLocaleString()));
        qparams.add((NameValuePair)new BasicNameValuePair("ts67", context.getPackageName()));
        qparams.add((NameValuePair)new BasicNameValuePair("ts68", UtilsBucksTracks.getApplicationName(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts69", UtilsBucksTracks.getAppVersionName(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts71", UtilsBucksTracks.getStringFromSP(context, "key_user_agent")));
        qparams.add((NameValuePair)new BasicNameValuePair("ts117", UtilsBucksTracks.getReferrer(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts73", UtilsBucksTracks.getIpAddress()));
        qparams.add((NameValuePair)new BasicNameValuePair("ts75", UtilsBucksTracks.getNetworkCode(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts76", UtilsBucksTracks.getScreenDensityDate(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts77", UtilsBucksTracks.getConnType(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts78", UtilsBucksTracks.getScreenSize(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts79", UtilsBucksTracks.getEventDate(context, actionId)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts80", action));
        qparams.add((NameValuePair)new BasicNameValuePair("ts81", actionId));
        qparams.add((NameValuePair)new BasicNameValuePair("ts82", UtilsBucksTracks.getConcurrencyCode(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts83", UtilsBucksTracks.getFacebookId(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts84", UtilsBucksTracks.getInstallDate(context)));
        qparams.add((NameValuePair)new BasicNameValuePair("ts88", UtilsBucksTracks.getTimeZone()));
        qparams.add((NameValuePair)new BasicNameValuePair("ts121", UtilsBucksTracks.getStringFromSP(context, "key_device_adv_id")));
        qparams.add((NameValuePair)new BasicNameValuePair("ts98", BuildBuckstracks.VERSION));
        qparams.add((NameValuePair)new BasicNameValuePair("ts89", UtilsBucksTracks.getStringFromSP(context, "key_gcm")));
        qparams.add((NameValuePair)new BasicNameValuePair("ts118", UtilsBucksTracks.getStringFromSP(context, "key_notification_id")));
        qparams.add((NameValuePair)new BasicNameValuePair("ts74", UtilsBucksTracks.getStringFromSP(context, "key_profile_id")));
        return qparams;
    }

    public String createUrl() {
        this.qparams = this.initParameter(this.context, this.action, this.actionId);
        this.addMoreParams(this.qparams, this.multiEvent);
        BucksLog.i(this.getClass().getName(), "Elementi di query string:");
        int count = 0;
        for (NameValuePair element : this.qparams) {
            BucksLog.i(this.getClass().getName(), count++ + ".  Key[" + element.getName() + "] Value[" + element.getValue() + "]");
        }
        return this.getUrl(this.qparams);
    }

    public String createUrlTest() {
        this.qparams = this.initParameter(this.context, this.action, this.actionId);
        this.addMoreParams(this.qparams, this.multiEvent);
        BucksLog.i(this.getClass().getName(), "Elementi di query string:");
        int count = 0;
        for (NameValuePair element : this.qparams) {
            BucksLog.i(this.getClass().getName(), count++ + ".  Key[" + element.getName() + "] Value[" + element.getValue() + "]");
        }
        return this.getUrlTest(this.qparams);
    }

    private String createLocaleString() {
        Locale l = Locale.getDefault();
        String locale = l.getLanguage() + "_" + l.getCountry();
        BucksLog.d(TAG, "Language, Country: " + locale);
        return locale;
    }

    private void addMoreParams(List<NameValuePair> qparams, MultiEventBean multiEventBean) {
        if (multiEventBean == null) {
            return;
        }
        Set<String> keySet = multiEventBean.getMultiEventMap().keySet();
        for (String key : keySet) {
            qparams.add((NameValuePair)new BasicNameValuePair(key, multiEventBean.getMultiEventMap().get(key)));
        }
    }

    String getUrl(List<NameValuePair> pQparams) {
        String url = "";
        if (this.isConfigComplete(this.context)) {
            try {
                URI uri = URIUtils.createURI((String)"http", (String)"tracking.bucksense.com", (int)80, (String)"/ts_m", (String)URLEncodedUtils.format(this.qparams, (String)"UTF-8"), null);
                url = uri.toString();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        BucksLog.i(this.getClass().getName(), "--> url[" + url + "]");
        return url;
    }

    String getUrlTest(List<NameValuePair> pQparams) {
        String url = "";
        if (this.isConfigComplete(this.context)) {
            try {
                URI uri = URIUtils.createURI((String)"http", (String)"beta.tracking.tatssense.com", (int)80, (String)"/ts_m", (String)URLEncodedUtils.format(this.qparams, (String)"UTF-8"), null);
                url = uri.toString();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        BucksLog.i(this.getClass().getName(), "--> url[" + url + "]");
        return url;
    }

    boolean isConfigComplete(Context context) {
        if (UtilsBucksTracks.getStringFromSP(context, "key_advertise_id").equals("")) {
            return false;
        }
        return UtilsBucksTracks.getMacAddr(context) != null;
    }

    public boolean hasResponse() {
        boolean res = false;
        if (this.action.equals("GCM")) {
            res = true;
        }
        return res;
    }

    public String getAction() {
        return this.action;
    }
}

