/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.bucstracks.rest;

import com.tatssense.core.bucstracks.BucksTracksUiConst;
import com.tatssense.core.bucstracks.rest.ApiService;
import com.tatssense.core.util.BucksLog;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.RetrofitError;

public class RestClient {
    private static final String TAG = "RestClient";
    private ApiService apiService;
    static final String FAKE_JSON_URL = "http://rm2.interactive-app.net";
    static final String BASE_URL = "http://beta.retargeting.tatssense.com";

    public static ApiService init() {
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setLogLevel(RestAdapter.LogLevel.FULL).setLog(new RestAdapter.Log(){

            public void log(String msg) {
                BucksLog.d(RestClient.TAG, msg);
            }
        }).setEndpoint(BASE_URL).setErrorHandler((ErrorHandler)new CustomErrorHandler());
        if (BucksTracksUiConst.DEBUG) {
            restBuilder.setEndpoint(FAKE_JSON_URL);
        } else {
            restBuilder.setEndpoint(BASE_URL);
        }
        RestAdapter restAdapter = restBuilder.build();
        return (ApiService)restAdapter.create(ApiService.class);
    }

    public ApiService getApiService() {
        return this.apiService;
    }

    static class CustomErrorHandler
    implements ErrorHandler {
        CustomErrorHandler() {
        }

        public Throwable handleError(RetrofitError cause) {
            return cause;
        }
    }
}

