/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.bucstracks.starter.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tatssense.core.bucstracks.beans.Response.CheckScreenRes;
import com.tatssense.core.bucstracks.screenclasses.SingleWVIntroWeb;
import com.tatssense.core.bucstracks.starter.controller.IActionScreen;
import com.tatssense.core.util.BucksLog;
import java.io.Serializable;

public class ActionIntroWeb
implements IActionScreen {
    public static String TAG = ActionIntroWeb.class.getSimpleName();
    Intent intent;
    Context context;

    private ActionIntroWeb(Context context, CheckScreenRes scType) {
        this.context = context;
        this.intent = new Intent();
        this.intent.putExtra("CheckScreenDataJsonObj", (Serializable)scType);
        this.intent.setFlags(0x10000000);
        try {
            this.intent.setClass(context, Class.forName("com.buckstracksui.ScIntroWebAct"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            BucksLog.e(TAG, "It seems you are not using UI module!");
        }
    }

    public static ActionIntroWeb buildInstance(Activity activity, CheckScreenRes scType) {
        return ActionIntroWeb.buildInstance(activity.getApplicationContext(), scType);
    }

    public static ActionIntroWeb buildInstance(Context context, CheckScreenRes scType) {
        ActionIntroWeb actionIntroWeb = new ActionIntroWeb(context, scType);
        return actionIntroWeb;
    }

    @Override
    public void executeAction() {
        new Handler(this.context.getMainLooper()).post((Runnable)new WebRunnable(this.context.getApplicationContext(), this.intent));
    }

    private static void startScreen(final Context context, final Intent in) {
        final WebView webview = new WebView(context);
        webview.getSettings().setJavaScriptEnabled(true);
        webview.clearCache(true);
        webview.setScrollBarStyle(0x2000000);
        webview.setVisibility(8);
        webview.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.i((String)TAG, (String)"Processing webview url click...");
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                Log.i((String)TAG, (String)("Finished loading URL: " + url));
                context.startActivity(in);
                webview.setVisibility(0);
            }
        });
        SingleWVIntroWeb.getInstance();
        SingleWVIntroWeb.setVw(webview);
        CheckScreenRes response = (CheckScreenRes)in.getExtras().getSerializable("CheckScreenDataJsonObj");
        webview.loadUrl(response.getResult().getConfig().getIntro().getWeb().getUrl());
    }

    static class WebRunnable
    implements Runnable {
        Context context;
        Intent intent;

        WebRunnable(Context context, Intent intent) {
            this.context = context;
            this.intent = intent;
        }

        @Override
        public void run() {
            ActionIntroWeb.startScreen(this.context, this.intent);
        }
    }
}

