/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.bucstracks.starter.controller;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tatssense.core.bucstracks.beans.Response.CheckScreenRes;
import com.tatssense.core.bucstracks.beans.Response.slide.Slider;
import com.tatssense.core.bucstracks.starter.controller.IActionScreen;
import com.tatssense.core.bucstracks.starter.controller.component.SwipeLayout;
import java.lang.ref.WeakReference;

public class ActionSlider
implements IActionScreen {
    Activity activity;
    FrameLayout support;
    Slider beanResponse;

    private ActionSlider(Activity activity, Slider beanResponse) {
        this.activity = activity;
        this.beanResponse = beanResponse;
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ActionSlider.this.init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void init() {
        if (this.activity == null) {
            new Throwable("Activity cannot be null!!!");
            return;
        }
        if (this.activity.findViewById(ActionSlider.getResourceId((Context)this.activity, "frameContainer", "id")) != null) {
            ViewGroup vg = (ViewGroup)this.activity.findViewById(0x1020002).getRootView();
            this.support = (FrameLayout)vg.findViewById(ActionSlider.getResourceId((Context)this.activity, "frameContainer", "id"));
            ((ViewGroup)this.support.getParent()).removeView((View)this.support);
        }
        LayoutInflater inflater = (LayoutInflater)this.activity.getSystemService("layout_inflater");
        this.support = (FrameLayout)inflater.inflate(ActionSlider.getResourceId((Context)this.activity, "slider_layout", "layout"), null);
        SwipeLayout slide = (SwipeLayout)this.support.findViewById(ActionSlider.getResourceId((Context)this.activity, "slide_banner", "id"));
        FrameLayout.LayoutParams param = (FrameLayout.LayoutParams)slide.getLayoutParams();
        if (this.beanResponse.getDocked().equals("top")) {
            param.gravity = 48;
            param.topMargin = -(param.height + 3);
        } else {
            param.gravity = 80;
            param.bottomMargin = -(param.height + 3);
        }
        slide.setDragEdge(SwipeLayout.DragEdge.Left);
        slide.addSwipeListener(new SwipeLayout.SwipeListener(){

            @Override
            public void onStartOpen(SwipeLayout layout) {
            }

            @Override
            public void onOpen(SwipeLayout layout) {
                ((ViewGroup)ActionSlider.this.support.getParent()).removeView((View)ActionSlider.this.support);
            }

            @Override
            public void onStartClose(SwipeLayout layout) {
            }

            @Override
            public void onClose(SwipeLayout layout) {
            }

            @Override
            public void onUpdate(SwipeLayout layout, int leftOffset, int topOffset) {
            }

            @Override
            public void onHandRelease(SwipeLayout layout, float xvel, float yvel) {
            }
        });
        this.activity.addContentView((View)this.support, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    public static ActionSlider buildInstance(Activity activity, Slider bean) {
        ActionSlider actionSlider = new ActionSlider(activity, bean);
        return actionSlider;
    }

    public static ActionSlider buildInstance(Activity activity, CheckScreenRes scType) {
        Slider sliderBean = scType.getResult().getConfig().getSlider();
        ActionSlider actionSlider = new ActionSlider(activity, sliderBean);
        return actionSlider;
    }

    @Override
    public void executeAction() {
        new Handler(this.activity.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                ActionSlider.this.moveSlider(ActionSlider.this.beanResponse);
            }
        }, 800L);
    }

    public void moveSlider(final Slider beanResponse) {
        if (beanResponse == null) {
            return;
        }
        this.support = (FrameLayout)this.activity.findViewById(ActionSlider.getResourceId((Context)this.activity, "frameContainer", "id"));
        final SwipeLayout test1 = (SwipeLayout)this.support.findViewById(ActionSlider.getResourceId((Context)this.activity, "slide_banner", "id"));
        FrameLayout.LayoutParams param = (FrameLayout.LayoutParams)test1.getLayoutParams();
        int[] i = new int[2];
        test1.getLocationOnScreen(i);
        RelativeLayout container = (RelativeLayout)this.support.findViewById(ActionSlider.getResourceId((Context)this.activity, "slider_text_container", "id"));
        TextView textContent = (TextView)this.support.findViewById(ActionSlider.getResourceId((Context)this.activity, "slider_text_content", "id"));
        container.setBackgroundColor(Color.parseColor((String)beanResponse.getBgColor()));
        textContent.setTextColor(Color.parseColor((String)beanResponse.getTextColor()));
        textContent.setText((CharSequence)beanResponse.getText());
        textContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String link = beanResponse.getActionV();
                String type = beanResponse.getActionT();
                if (!type.equals("url") || link == null || link.equals("")) {
                    ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{-test1.getHeight(), 0.0f}).start();
                } else {
                    Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                    ActionSlider.this.activity.startActivity(new Intent(browserIntent));
                }
            }
        });
        if (param.gravity == 80) {
            if (ActionSlider.isVisible((View)test1, this.activity)) {
                ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{-test1.getHeight(), 0.0f}).start();
            } else {
                ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{0.0f, -test1.getHeight()}).start();
            }
        } else if (ActionSlider.isVisible((View)test1, this.activity)) {
            ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{test1.getHeight(), 0.0f}).start();
        } else {
            ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{0.0f, test1.getHeight()}).start();
        }
        new Handler().postDelayed((Runnable)new AnimationCustom(this.activity), (long)beanResponse.getDuration().intValue());
    }

    static boolean isVisible(View view, Activity activity) {
        int[] i = new int[2];
        DisplayMetrics displaymetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int height = displaymetrics.heightPixels;
        int width = displaymetrics.widthPixels;
        view.getLocationOnScreen(i);
        return i[1] > 0 && i[1] < height;
    }

    public static int getResourceId(Context context, String name, String defType) {
        int resID = context.getResources().getIdentifier(name, defType, context.getPackageName());
        return resID;
    }

    static class AnimationCustom
    implements Runnable {
        WeakReference<Activity> act;

        AnimationCustom(Activity activity) {
            this.act = new WeakReference<Activity>(activity);
        }

        @Override
        public void run() {
            Activity activity = (Activity)this.act.get();
            if (activity == null) {
                return;
            }
            FrameLayout support = (FrameLayout)activity.findViewById(ActionSlider.getResourceId((Context)activity, "frameContainer", "id"));
            if (support == null) {
                return;
            }
            SwipeLayout test1 = (SwipeLayout)support.findViewById(ActionSlider.getResourceId((Context)activity, "slide_banner", "id"));
            if (!ActionSlider.isVisible((View)test1, activity)) {
                return;
            }
            FrameLayout.LayoutParams param = (FrameLayout.LayoutParams)test1.getLayoutParams();
            if (param.gravity == 80) {
                ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{-test1.getHeight(), 0.0f}).start();
            } else {
                ObjectAnimator.ofFloat((Object)((Object)test1), (String)"translationY", (float[])new float[]{test1.getHeight(), 0.0f}).start();
            }
        }
    }
}

