/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.configuration;

import android.content.Context;
import android.content.Intent;
import com.google.gson.Gson;
import com.tatssense.core.bean.LinkerBean;
import com.tatssense.core.bean.ResGcmBean;
import com.tatssense.core.model.Events;
import com.tatssense.core.model.ManageEvent;
import com.tatssense.core.util.BucksLog;
import com.tatssense.core.util.ConstTracker;
import com.tatssense.core.util.UtilsBucksTracks;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class ManageLink_v2
implements Runnable {
    private String link;
    public int status = -2;
    HttpClient httpClient;
    HttpResponse response = null;
    boolean isNewCalls = true;
    Events events = null;
    LinkerBean linker;
    Context ctx;
    public static int i = 0;

    public ManageLink_v2(Context context, LinkerBean linker, boolean isNewCalls) {
        this.linker = linker;
        this.ctx = context;
        this.httpClient = this.getHttpClient();
        this.isNewCalls = isNewCalls;
    }

    public ManageLink_v2(Context context, Events events, boolean isNewCalls) {
        this.events = events;
        this.ctx = context;
        this.httpClient = this.getHttpClient();
        this.isNewCalls = isNewCalls;
    }

    private HttpClient getHttpClient() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager((HttpParams)params, registry);
        return new DefaultHttpClient((ClientConnectionManager)connManager, (HttpParams)params);
    }

    @Override
    public void run() {
        if (this.events != null) {
            this.link = this.events.getLink_to_send();
        }
        if (this.linker == null) {
            return;
        }
        this.link = this.linker.createUrl();
        if (this.link == null || this.link.equals("")) {
            BucksLog.e(this.getClass().getName(), "link[" + this.link + "] NON e' valorizzato!!!!");
            return;
        }
        HttpGet request = new HttpGet(this.link);
        try {
            if (ConstTracker.IS_TEST) {
                this.httpClient.execute((HttpUriRequest)new HttpGet(this.linker.createUrlTest()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.response = this.httpClient.execute((HttpUriRequest)request);
            this.status = this.response.getStatusLine().getStatusCode();
            if (this.status == 200) {
                if (this.events != null) {
                    ManageEvent.getInstance(this.ctx).deleteEvent(this.events);
                }
            } else {
                this.saveCall(this.link);
                return;
            }
            this.manageResponse(this.linker, this.response);
            BucksLog.d(this.getClass().getName(), "ManageLink_v2 - Event was sent");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            this.saveCall(this.link);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.saveCall(this.link);
        }
    }

    private void manageResponse(LinkerBean linker, HttpResponse response) throws IllegalStateException, IOException {
        InputStream in;
        String responseString;
        if (linker.getAction() != null && linker.getAction().equals("OPEN")) {
            UtilsBucksTracks.saveStringInSP(this.ctx, "key_notification_id", "");
        }
        if ((responseString = this.processStream(in = response.getEntity().getContent())).equals("")) {
            return;
        }
        Gson gs = new Gson();
        try {
            ResGcmBean res = (ResGcmBean)gs.fromJson(responseString, ResGcmBean.class);
            BucksLog.d(this.getClass().getName(), "ResGcmBean responseString[" + responseString + "] res.gcm_push_id[" + res.gcm_push_id + "]");
            if (res.gcm_push_id != null && !res.gcm_push_id.isEmpty()) {
                UtilsBucksTracks.saveStringInSP(this.ctx, "key_psh_id", res.gcm_push_id);
                Intent intent = new Intent("com.google.android.c2dm.intent.RECEIVE");
                intent.putExtra("key_receiver_trasmit_regid_pshid", "key_receiver_trasmit_regid_pshid");
                intent.putExtra("key_pushid_arrived", res.gcm_push_id);
                this.ctx.sendBroadcast(intent);
                BucksLog.d(this.getClass().getName(), i++ + ". action:  [" + linker.getAction() + "]  gcm push id [" + res.gcm_push_id + "]");
            }
        }
        catch (Exception ex) {
            BucksLog.e(this.getClass().getName(), "error with response of ManageLink_v2");
            ex.printStackTrace();
        }
    }

    void saveCall(String link) {
        if (!this.isNewCalls) {
            return;
        }
        long id = ManageEvent.getInstance(this.ctx).saveLink(link);
        BucksLog.i(this.getClass().getName(), "saved link[" + link + "] id[" + id + "]");
    }

    private String processStream(InputStream source) {
        if (source == null) {
            return "";
        }
        InputStreamReader reader = new InputStreamReader(source);
        StringBuffer buff = new StringBuffer();
        try {
            int data = ((Reader)reader).read();
            while (data != -1) {
                char dataChar = (char)data;
                data = ((Reader)reader).read();
                buff.append(dataChar);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buff.toString();
    }
}

