/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.gson.Gson;
import com.tatssense.core.bean.notification.NotificationBean;
import com.tatssense.core.bean.notification.SupportNotificationBean;
import com.tatssense.core.gcm.GcmBroadcastReceiver;
import com.tatssense.core.gcm.TestIntentService;
import com.tatssense.core.util.BucksLog;
import com.tatssense.core.util.UtilsBucksTracks;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

public abstract class GcmIntentService
extends TestIntentService {
    public static final int NOTIFICATION_ID = 1;
    NotificationCompat.Builder builder;
    public static final String TAG = "GCM Demo";

    public GcmIntentService() {
        super("GcmIntentService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onHandleIntent(Intent intent) {
        block14: {
            SupportNotificationBean support = null;
            NotificationBean notification = null;
            try {
                Gson gs;
                String text;
                Bundle extras;
                block15: {
                    extras = intent.getExtras();
                    GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)this);
                    String messageType = gcm.getMessageType(intent);
                    if (extras.isEmpty()) break block14;
                    if ("send_error".equals(messageType)) {
                        this.recivedErrorMsgFromServer(extras.toString());
                        break block14;
                    }
                    if ("deleted_messages".equals(messageType)) {
                        this.deleteMessageFromServer(extras.toString());
                        break block14;
                    }
                    if (!"gcm".equals(messageType)) break block14;
                    BucksLog.i(TAG, "Completed work @ " + SystemClock.elapsedRealtime());
                    text = (String)extras.get("message");
                    if (text == null) {
                        text = extras.getString("msg");
                    }
                    gs = new Gson();
                    support = (SupportNotificationBean)gs.fromJson(text, SupportNotificationBean.class);
                    if (support != null) break block15;
                    Log.e((String)TAG, (String)"Error with received json");
                    return;
                }
                try {
                    notification = support.getNotificationBean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    notification = (NotificationBean)gs.fromJson(text, NotificationBean.class);
                }
                if (extras.containsKey("notification_id")) {
                    notification.notificationId = (String)extras.get("notification_id");
                }
                if (notification.auto_display) {
                    this.sendNotificationBroadcast(notification.text, notification);
                }
                this.recivedMessageFromServer(notification.intent_data);
                BucksLog.i(TAG, "Received: " + extras);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
            }
        }
    }

    protected abstract void deleteMessageFromServer(String var1);

    protected abstract void recivedErrorMsgFromServer(String var1);

    protected abstract void recivedMessageFromServer(String var1);

    private void sendNotification(String msg, NotificationBean noty) throws Exception {
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
        Intent intent = new Intent(noty.intent_action);
        intent.putExtra("extra_data", noty.intent_data);
        PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)1, (Intent)intent, (int)0x48000000);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this).setLargeIcon(this.getBitmapFromURL(noty.image_url, this.getResources().getDimensionPixelSize(17104902), this.getResources().getDimensionPixelSize(0x1050005))).setContentTitle((CharSequence)noty.title).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)msg)).setContentText((CharSequence)msg).setSmallIcon(this.getApplicationInfo().icon).setDefaults(7);
        mBuilder.setContentIntent(resultPendingIntent);
        Notification note = mBuilder.build();
        note.flags |= 0x10;
        mNotificationManager.notify(1, note);
    }

    public Bitmap getBitmapFromURL(String strURL, int h, int w) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream((InputStream)input);
            myBitmap = Bitmap.createScaledBitmap((Bitmap)myBitmap, (int)w, (int)h, (boolean)false);
            return myBitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void sendNotificationBroadcast(String msg, NotificationBean noty) {
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
        int notif_id = 0;
        if (UtilsBucksTracks.isThereThatKeyInSP(this.getApplicationContext(), "key_allow_multiple")) {
            if (UtilsBucksTracks.getBooleanFromSP(this.getApplicationContext(), "key_allow_multiple")) {
                notif_id = new Random().nextInt();
            }
        } else {
            try {
                notif_id = (int)Long.parseLong(UtilsBucksTracks.getStringFromSP(this.getApplicationContext(), "SENDER_ID_GCM")) % Integer.MAX_VALUE;
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        Intent intent = new Intent("com.google.android.c2dm.intent.RECEIVE");
        intent.addCategory(this.getPackageName());
        intent.putExtra("key_receiver_notificatio_click", "key_receiver_notificatio_click");
        intent.putExtra("extra_data", (Serializable)noty);
        PendingIntent resultPendingIntent = PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)notif_id, (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this).setLargeIcon(this.getBitmapFromURL(noty.image_url, this.getResources().getDimensionPixelSize(17104902), this.getResources().getDimensionPixelSize(0x1050005))).setContentTitle((CharSequence)noty.title).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)msg)).setContentText((CharSequence)msg).setDefaults(7);
        if (noty.icon != null && !noty.icon.equals("")) {
            mBuilder.setSmallIcon(this.getApplicationContext().getResources().getIdentifier(noty.icon, "drawable", this.getApplicationContext().getPackageName()));
        } else {
            mBuilder.setSmallIcon(this.getApplicationInfo().icon);
        }
        mBuilder.setContentIntent(resultPendingIntent);
        Notification note = mBuilder.build();
        note.flags |= 0x10;
        mNotificationManager.notify(notif_id, note);
    }
}

