/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.gcm;

import android.content.Context;
import com.tatssense.core.bucstracks.beans.Request.CheckScreenReq;
import com.tatssense.core.bucstracks.beans.Response.CheckScreenRes;
import com.tatssense.core.bucstracks.controller.databean.InDataBeanActivityScreen;
import com.tatssense.core.bucstracks.screenclasses.CallbackInt;
import com.tatssense.core.bucstracks.screenclasses.GetScreenThread;
import com.tatssense.core.bucstracks.starter.controller.ActionController;
import com.tatssense.core.bucstracks.starter.controller.ActionIntroNative;
import com.tatssense.core.bucstracks.starter.controller.ActionIntroVideo;
import com.tatssense.core.bucstracks.starter.controller.ActionIntroWeb;
import com.tatssense.core.bucstracks.starter.controller.ActionOverlayNative;
import com.tatssense.core.bucstracks.starter.controller.ActionOverlayWeb;
import com.tatssense.core.util.BucksLog;

class ScreenMasterImpl {
    Context ctx;
    CallbackInt listner;

    ScreenMasterImpl(Context ctx, String cid) {
        this.ctx = ctx;
        this.listner = new ListnerCallBack(ctx);
        new Thread(new GetScreenThread(ctx.getApplicationContext(), CheckScreenReq.newInstanceCampainId(ctx, cid), this.listner)).start();
    }

    public static ScreenMasterImpl createInstance(Context context, String cid) {
        ScreenMasterImpl screenMaster = new ScreenMasterImpl(context, cid);
        return screenMaster;
    }

    static class ListnerCallBack
    implements CallbackInt {
        private CheckScreenRes checkScreenRes = null;
        Context ctx;

        public ListnerCallBack(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        public void callbackMethod(CheckScreenRes scType) {
            this.checkScreenRes = scType;
            if (scType != null && scType.getError() != null && scType.getError().getCode() == 0) {
                if (scType.getResult() != null && scType.getResult().getConfig() != null && scType.getResult().getConfig().getType() != null) {
                    String type = scType.getResult().getConfig().getType();
                    ActionController actionController = null;
                    if (type.equalsIgnoreCase(InDataBeanActivityScreen.TYPE_SCREEN_BEAN.OVERLAY.toString())) {
                        String subtype = scType.getResult().getConfig().getOverlay().getSubType();
                        if (subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.NATIVE.toString())) {
                            actionController = new ActionController(ActionOverlayNative.buildInstance(this.ctx, scType));
                        } else if (subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.WEB.toString())) {
                            actionController = new ActionController(ActionOverlayWeb.buildInstance(this.ctx, scType));
                        }
                    } else if (type.equalsIgnoreCase(InDataBeanActivityScreen.TYPE_SCREEN_BEAN.INTRO.toString())) {
                        String subtype = scType.getResult().getConfig().getIntro().getSub_type();
                        if (subtype != null && subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.NATIVE.toString())) {
                            actionController = new ActionController(ActionIntroNative.buildInstance(this.ctx, scType));
                        } else if (subtype != null && subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.WEB.toString())) {
                            actionController = new ActionController(ActionIntroWeb.buildInstance(this.ctx, scType));
                        } else if (subtype != null && subtype.equalsIgnoreCase(InDataBeanActivityScreen.SUB_TYPE_SCREEN_BEAN.VIDEO.toString())) {
                            actionController = new ActionController(ActionIntroVideo.buildInstance(this.ctx, scType));
                        }
                    }
                    if (actionController != null) {
                        actionController.startAction();
                    }
                }
            } else if (scType.getError() != null) {
                BucksLog.e(ScreenMasterImpl.class.getSimpleName(), "error message[" + scType.getError().getMessage() + "]");
            }
        }

        @Override
        public void responseError(String obj, int code) {
        }
    }
}

