/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.gcm;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import com.tatssense.core.bean.LinkerBean;
import com.tatssense.core.bean.MultiEventBean;
import com.tatssense.core.configuration.ManageLink_v2;
import com.tatssense.core.util.BucksLog;

abstract class TestIntentService
extends Service {
    private volatile Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;
    private String mName;
    private boolean mRedelivery;
    private int countIncomingAction;
    private int startIdToStop;
    private Context context;
    public static String TAG = "TestIntentService";
    public static String TRACK_ACTION_KEY = "track_action_key";
    public static String LOAD_LANDING_KEY = "load_landing";
    public static int LOAD_LANDING = 1002;
    protected static int TRACK_ACTION = 1001;

    public TestIntentService(String name) {
        this.mName = name;
        this.countIncomingAction = 0;
        this.context = this;
    }

    public void setIntentRedelivery(boolean enabled) {
        this.mRedelivery = enabled;
    }

    public void onCreate() {
        super.onCreate();
        HandlerThread thread = new HandlerThread("IntentService[" + this.mName + "]");
        thread.start();
        this.mServiceLooper = thread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public void onStart(Intent intent, int startId) {
        this.startIdToStop = startId;
        Message msg = this.mServiceHandler.obtainMessage();
        if (intent.getExtras() != null && intent.getExtras().containsKey(TRACK_ACTION_KEY)) {
            msg.what = TRACK_ACTION;
            msg.obj = intent.getExtras().get(TRACK_ACTION_KEY);
        } else if (intent.getExtras() != null && intent.getExtras().containsKey(LOAD_LANDING_KEY)) {
            msg.what = LOAD_LANDING;
            msg.obj = intent.getExtras().get(LOAD_LANDING_KEY);
        } else {
            msg.arg1 = startId;
            msg.obj = intent;
        }
        ++this.countIncomingAction;
        this.mServiceHandler.sendMessage(msg);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.onStart(intent, startId);
        return this.mRedelivery ? 3 : 2;
    }

    public void onDestroy() {
        this.mServiceLooper.quit();
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected abstract void onHandleIntent(Intent var1);

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == TRACK_ACTION) {
                if (msg.obj instanceof MultiEventBean) {
                    MultiEventBean multiEvent = (MultiEventBean)msg.obj;
                    this.executeInternal(new ManageLink_v2(TestIntentService.this.context, new LinkerBean(TestIntentService.this.context, multiEvent), true));
                }
            } else {
                TestIntentService.this.onHandleIntent((Intent)msg.obj);
            }
            TestIntentService.this.countIncomingAction--;
            if (TestIntentService.this.countIncomingAction == 0) {
                TestIntentService.this.stopSelf(TestIntentService.this.startIdToStop);
                BucksLog.v(TAG, TAG + " was stopped!!!");
            }
        }

        private void executeInternal(Runnable task) {
            try {
                task.run();
            }
            catch (Throwable t) {
                BucksLog.e(TAG, "run task: " + task, t);
            }
        }
    }
}

