/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.model;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.tatssense.core.model.DaoSession;
import com.tatssense.core.model.EventsDao;
import com.tatssense.core.util.BucksLog;
import de.greenrobot.dao.AbstractDaoMaster;
import de.greenrobot.dao.identityscope.IdentityScopeType;

public class DaoMaster
extends AbstractDaoMaster {
    public static final int SCHEMA_VERSION = 3;

    public static void createAllTables(SQLiteDatabase db, boolean ifNotExists) {
        EventsDao.createTable(db, ifNotExists);
    }

    public static void dropAllTables(SQLiteDatabase db, boolean ifExists) {
        EventsDao.dropTable(db, ifExists);
    }

    public DaoMaster(SQLiteDatabase db) {
        super(db, 3);
        this.registerDaoClass(EventsDao.class);
    }

    public DaoSession newSession() {
        return new DaoSession(this.db, IdentityScopeType.Session, this.daoConfigMap);
    }

    public DaoSession newSession(IdentityScopeType type) {
        return new DaoSession(this.db, type, this.daoConfigMap);
    }

    public static class DevOpenHelper
    extends OpenHelper {
        public DevOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            BucksLog.i("greenDAO", "Upgrading schema from version " + oldVersion + " to " + newVersion + " by dropping all tables");
            DaoMaster.dropAllTables(db, true);
            this.onCreate(db);
        }
    }

    public static abstract class OpenHelper
    extends SQLiteOpenHelper {
        public OpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory) {
            super(context, name, factory, 3);
        }

        public void onCreate(SQLiteDatabase db) {
            BucksLog.i("greenDAO", "Creating tables for schema version 3");
            DaoMaster.createAllTables(db, false);
        }
    }
}

