/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.task;

import android.os.Handler;
import com.tatssense.core.task.AbstractRunnable;
import com.tatssense.core.util.BucksLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class JsonHandlerTaskSender
extends AbstractRunnable {
    private String url = null;
    private String jsonToSend = null;
    private String keyRequest = null;

    public JsonHandlerTaskSender(Handler handler, String url, String jsonToSend, String keyRequest) {
        super(handler);
        this.url = url;
        this.jsonToSend = jsonToSend;
        this.keyRequest = keyRequest;
    }

    public JsonHandlerTaskSender(Handler handler) {
        super(handler);
    }

    @Override
    protected void doRun() {
        if (this.url == null || this.url.equals("") || this.jsonToSend == null || this.jsonToSend.equals("")) {
            BucksLog.e(this.getClass().getName(), "Errore passaggio parametri!!! url[" + this.url + "] jsonToSend[" + this.jsonToSend + "]");
            return;
        }
        BucksLog.i(this.getClass().getName(), "Request url[" + this.url + "]");
        BucksLog.i(this.getClass().getName(), "Request jsonToSend[" + this.jsonToSend + "]");
        InputStream resInputStream = this.retrieveStream(this.url, this.jsonToSend);
        String jsonRes = this.processStream(resInputStream);
        BucksLog.i(this.getClass().getName(), "Res keyRequest[" + this.keyRequest + "]   jsonRes[" + jsonRes + "]");
        this.handler.obtainMessage(1, (Object)"").sendToTarget();
    }

    private InputStream retrieveStream(String url, String jsonToSend) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)10000);
        try {
            HttpPost post = new HttpPost(url);
            StringEntity se = new StringEntity(jsonToSend);
            se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
            post.setEntity((HttpEntity)se);
            HttpResponse getResponse = client.execute((HttpUriRequest)post);
            int statusCode = getResponse.getStatusLine().getStatusCode();
            BucksLog.i(this.getClass().getName(), "statusCode[" + statusCode + "]");
            HttpEntity getResponseEntity = getResponse.getEntity();
            return getResponseEntity.getContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            BucksLog.e(this.getClass().getName(), "Action[" + this.keyRequest + "] Exception[" + e.getMessage() + "] url[" + url + "]");
            return null;
        }
    }

    private String processStream(InputStream source) {
        if (source == null) {
            return "";
        }
        InputStreamReader reader = new InputStreamReader(source);
        StringBuffer buff = new StringBuffer();
        try {
            int data = ((Reader)reader).read();
            while (data != -1) {
                char dataChar = (char)data;
                data = ((Reader)reader).read();
                buff.append(dataChar);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            BucksLog.e(this.getClass().getName(), "Action[" + this.keyRequest + "] Exception[" + e.getMessage() + "] url[" + this.url + "]");
        }
        return buff.toString();
    }
}

