/*
 * Decompiled with CFR 0.152.
 */
package com.tatssense.core.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.tatssense.core.configuration.ManageFacebook;
import com.tatssense.core.util.BucksLog;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.util.InetAddressUtils;

public class UtilsBucksTracks {
    private static final String TAG = UtilsBucksTracks.class.getCanonicalName();

    public static String getStringFromSP(Context context, String key) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        return settings.getString(key, "");
    }

    public static boolean removeStringFromSP(Context context, String key) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        return settings.edit().remove(key).commit();
    }

    public static boolean getBooleanFromSP(Context context, String key) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        return settings.getBoolean(key, false);
    }

    public static int getIntFromSP(Context context, String key) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        return settings.getInt(key, 0);
    }

    public static long getLongFromSP(Context context, String key) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        return settings.getLong(key, -1L);
    }

    public static boolean saveStringInSP(Context context, String key, String value) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public static boolean clearAllData(Context context) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        settings.edit().clear().commit();
        boolean res = settings.getAll().isEmpty();
        return res;
    }

    public static boolean saveBooleanInSP(Context context, String key, boolean value) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(key, value);
        return editor.commit();
    }

    public static boolean saveIntInSP(Context context, String key, int value) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value);
        return editor.commit();
    }

    public static boolean saveLongInSP(Context context, String key, long value) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        SharedPreferences.Editor editor = settings.edit();
        editor.putLong(key, value);
        return editor.commit();
    }

    public static boolean isThereThatKeyInSP(Context context, String key) {
        SharedPreferences settings = UtilsBucksTracks.getSharedPreferences(context);
        return settings.contains(key);
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static String getMacAddr(Context context) {
        String mac = "";
        WifiManager wifiMan = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiMan.getConnectionInfo();
        if (wifiInfo != null && wifiInfo.getMacAddress() != null) {
            mac = wifiInfo.getMacAddress();
        }
        return mac;
    }

    public static String getOdin(Context context) {
        String odin = "";
        odin = UtilsBucksTracks.sha1(UtilsBucksTracks.getMacAddr(context));
        return odin;
    }

    public static String getMacAddressAlpha(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.replaceDataString(UtilsBucksTracks.getMacAddr(context).toUpperCase(), ":", "");
        return mac;
    }

    public static String getMacAddressAlphal(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.replaceDataString(UtilsBucksTracks.getMacAddr(context).toLowerCase(), ":", "");
        return mac;
    }

    public static String getMacAddressAlphaMD5l(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.md5Hashing(UtilsBucksTracks.getMacAddr(context).toLowerCase());
        return mac;
    }

    public static String getMacAddressAlphaMD5(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.md5Hashing(UtilsBucksTracks.getMacAddr(context).toLowerCase());
        return mac;
    }

    public static String getMacAddressl(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.getMacAddr(context).toLowerCase();
        return mac;
    }

    public static String getMacAddressMD5(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.md5Hashing(UtilsBucksTracks.getMacAddr(context));
        return mac;
    }

    public static String getMacAddressMD5l(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.md5Hashing(UtilsBucksTracks.getMacAddr(context).toLowerCase());
        return mac;
    }

    public static String getMacAddressSha1(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.sha1(UtilsBucksTracks.getMacAddr(context));
        return mac;
    }

    public static String getMacAddressSha1l(Context context) {
        String mac = "";
        mac = UtilsBucksTracks.sha1(UtilsBucksTracks.getMacAddr(context).toLowerCase());
        return mac;
    }

    public static String getMacAddrAlphalSha1(Context context) {
        String temp = UtilsBucksTracks.replaceDataString(UtilsBucksTracks.getMacAddr(context).toLowerCase(), ":", "");
        return UtilsBucksTracks.sha1(temp.toLowerCase());
    }

    public static String getMacAddressAlphalMD5(Context context) {
        String temp = UtilsBucksTracks.replaceDataString(UtilsBucksTracks.getMacAddr(context), ":", "");
        return UtilsBucksTracks.md5Hashing(temp.toLowerCase());
    }

    public static String getUnid(Context context) {
        String acoId = UtilsBucksTracks.getStringFromSP(context, "aco_id");
        if (acoId.length() == 0) {
            acoId = UUID.randomUUID().toString();
            UtilsBucksTracks.saveStringInSP(context, "aco_id", acoId);
        }
        return acoId;
    }

    public static String getCarrier(Context context) {
        String carrier = "";
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm.getSimOperatorName() != null) {
            carrier = tm.getSimOperatorName();
        }
        return carrier;
    }

    public static String getApplicationName(Context context) {
        int stringId = context.getApplicationInfo().labelRes;
        return context.getString(stringId);
    }

    public static String getAppVersion(Context context) {
        String version = "";
        try {
            version = String.valueOf(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static String getAppVersionName(Context context) {
        String version = "";
        try {
            version = String.valueOf(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static String getCountryCode(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String country = "";
        if (tm.getSimCountryIso() != null) {
            country = tm.getSimCountryIso();
        }
        return country;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTrackingId(Context context) {
        String trackingId = "";
        Uri allTitles = Uri.parse((String)("content://" + context.getPackageName() + "/referrer_apps"));
        Cursor c = context.getContentResolver().query(allTitles, null, null, null, "publisher_package_name desc");
        if (c != null && c.moveToFirst()) {
            trackingId = c.getString(c.getColumnIndex("transid"));
            try {
                trackingId = URLEncoder.encode(trackingId, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    c.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return trackingId;
    }

    public static String getIpAddress() {
        try {
            ArrayList<NetworkInterface> nilist = Collections.list(NetworkInterface.getNetworkInterfaces());
            if (nilist.size() > 0) {
                for (NetworkInterface ni : nilist) {
                    ArrayList<InetAddress> ialist = Collections.list(ni.getInetAddresses());
                    if (ialist.size() <= 0) continue;
                    for (InetAddress address : ialist) {
                        String ipv4;
                        if (address.isLoopbackAddress() || !InetAddressUtils.isIPv4Address((String)(ipv4 = address.getHostAddress()))) continue;
                        return String.copyValueOf(ipv4.toCharArray());
                    }
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public static String getNetworkCode(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String networkOperator = tm.getNetworkOperator();
        return networkOperator;
    }

    public static String getNetworkName(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String networkOperatorName = tm.getNetworkOperatorName();
        return networkOperatorName;
    }

    public static String getScreenDensityDate(Context context) {
        float density = context.getResources().getDisplayMetrics().density;
        if ((double)density == 0.75) {
            return "ldpi";
        }
        if ((double)density == 1.0) {
            return "mdpi";
        }
        if ((double)density == 1.5) {
            return "hdpi";
        }
        if ((double)density == 2.0) {
            return "xhdpi";
        }
        return "xxhdpi";
    }

    public static String getConnType(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mWifi = connManager.getNetworkInfo(1);
        if (mWifi.isConnected()) {
            return "WIFI";
        }
        return "MOBILE";
    }

    public static String getInstallDate(Context context) {
        try {
            long installed = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
            Date installDate = new Date(installed);
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            sdfDate.setTimeZone(TimeZone.getTimeZone("gmt"));
            String dateString = sdfDate.format(installDate);
            return dateString;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static String getFacebookId(Context context) {
        ManageFacebook fb = new ManageFacebook(context);
        if (fb.getFacebookAttributionId() != null) {
            return fb.getFacebookAttributionId();
        }
        return "";
    }

    public static String getConcurrencyCode(Context context) {
        Currency c = null;
        try {
            c = Currency.getInstance(Locale.getDefault());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c != null ? c.getCurrencyCode() : "";
    }

    public static String getEventDate(Context context, String eventId) {
        String eventDate = "";
        eventDate = eventId != null && (eventId.equals("1") || eventId.equals("2")) ? UtilsBucksTracks.UTCdate(context) : UtilsBucksTracks.UTCCurrentdate(context);
        return eventDate;
    }

    public static String getDeviceId(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getDeviceId();
    }

    public static String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getScreenSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        int width = wm.getDefaultDisplay().getWidth();
        int height = wm.getDefaultDisplay().getHeight();
        String res = String.valueOf(Integer.toString(width)) + "x" + Integer.toString(height);
        return res;
    }

    public static String sha2(String s) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        digest.reset();
        byte[] data = digest.digest(s.getBytes());
        return String.format("%0" + data.length * 2 + "X", new BigInteger(1, data));
    }

    public static String sha1(String input) {
        if (input == null) {
            return null;
        }
        MessageDigest mDigest = null;
        try {
            mDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] result = mDigest.digest(input.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            sb.append(Integer.toString((result[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static boolean containsChar(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo() != null;
    }

    public static String md5Hashing(String toMD5) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(toMD5.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    static String wifiIpAddress(Context context) {
        String ipAddressString;
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        int ipAddress = wifiManager.getConnectionInfo().getIpAddress();
        if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ipAddress = Integer.reverseBytes(ipAddress);
        }
        byte[] ipByteArray = BigInteger.valueOf(ipAddress).toByteArray();
        try {
            ipAddressString = InetAddress.getByAddress(ipByteArray).getHostAddress();
        }
        catch (UnknownHostException ex) {
            BucksLog.e("WIFIIP", "Unable to get host address.");
            ipAddressString = null;
        }
        return ipAddressString;
    }

    public static String replaceDataString(String toReplace, String old, String replaced) {
        String result = toReplace.replace(old, "");
        return result;
    }

    public static String UTCdate(Context context) {
        String appFile = null;
        try {
            appFile = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        long insdate = new File(appFile).lastModified();
        Date installDate = new Date(insdate);
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        sdfDate.setTimeZone(TimeZone.getTimeZone("gmt"));
        String dateString = sdfDate.format(installDate);
        return dateString;
    }

    public static String UTCCurrentdate(Context context) {
        Date installDate = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdfDate.setTimeZone(TimeZone.getTimeZone("gmt"));
        String dateString = sdfDate.format(installDate);
        return dateString;
    }

    public static void saveGPSData(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        List providers = lm.getProviders(true);
        Location l = null;
        for (int i = providers.size() - 1; i >= 0 && (l = lm.getLastKnownLocation((String)providers.get(i))) == null; --i) {
        }
        if (l != null) {
            UtilsBucksTracks.saveStringInSP(context, "latitude", String.valueOf(l.getLatitude()));
            UtilsBucksTracks.saveStringInSP(context, "longitude", String.valueOf(l.getLongitude()));
        }
    }

    public static String getReferrer(Context context) {
        String referrer = "";
        if (!UtilsBucksTracks.getStringFromSP(context, "referrer").equals("")) {
            referrer = UtilsBucksTracks.getStringFromSP(context, "referrer");
            BucksLog.i("Utils ", "Referrer from acotracker[" + referrer + "]");
        } else {
            SharedPreferences sp = context.getSharedPreferences("mat_referrer", 0);
            referrer = sp.getString("referrer", "");
            if (!referrer.equals("")) {
                BucksLog.i("Utils ", "Referrer from Acotracker[" + referrer + "]");
            }
        }
        if (referrer.contains("transid=")) {
            try {
                referrer = referrer.replace("transid=", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return referrer;
    }

    public static String sign(long i) {
        if (i == 0L) {
            return String.valueOf(i);
        }
        if (i >> 63 != 0L) {
            return String.valueOf(i);
        }
        return "+" + String.valueOf(i);
    }

    public static String getTimeZone() {
        String res = "";
        try {
            GregorianCalendar mCalendar = new GregorianCalendar();
            TimeZone mTimeZone = ((Calendar)mCalendar).getTimeZone();
            String region = mTimeZone.getID();
            long mGMTOffset = mTimeZone.getRawOffset();
            res = UtilsBucksTracks.sign(TimeUnit.HOURS.convert(mGMTOffset, TimeUnit.MILLISECONDS)) + " " + region;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static int sign(int i) {
        if (i == 0) {
            return 0;
        }
        if (i >> 31 != 0) {
            return -1;
        }
        return 1;
    }

    public static int getDimIconNotification(Context context) {
        int dim = 48;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int densityDpi = dm.densityDpi;
        switch (densityDpi) {
            case 120: {
                dim = 36;
                break;
            }
            case 160: {
                dim = 48;
                break;
            }
            case 240: {
                dim = 72;
                break;
            }
            case 320: {
                dim = 96;
            }
        }
        return dim;
    }

    public static String getAdvertisingIdClient(Context context) {
        String id = "";
        try {
            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            id = adInfo.getId();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return id;
        }
        catch (GooglePlayServicesRepairableException e) {
            e.printStackTrace();
            return id;
        }
        catch (IOException e) {
            e.printStackTrace();
            return id;
        }
        catch (GooglePlayServicesNotAvailableException e) {
            e.printStackTrace();
            return id;
        }
        return id;
    }

    public static Intent getLaucherInten(Context context) {
        Intent intent = null;
        PackageManager packageManager = context.getPackageManager();
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME"), 65536)) {
            if (context.getPackageName().equals(resolveInfo.activityInfo.packageName)) continue;
            intent = packageManager.getLaunchIntentForPackage(context.getPackageName());
            break;
        }
        return intent;
    }

    public static boolean isIntentActionAvailable(Context context, String action) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent = new Intent(action), 65536);
        return list.size() > 0;
    }

    public static String getMetaData(Context context, String key) {
        String metadata = null;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            metadata = bundle.getString(key);
        }
        catch (PackageManager.NameNotFoundException e) {
            BucksLog.e(TAG, "Failed to load meta-data, NameNotFound: " + e.getMessage());
        }
        catch (NullPointerException e) {
            BucksLog.e(TAG, "Failed to load meta-data, NullPointer: " + e.getMessage());
        }
        return metadata;
    }

    public static String getMetadataGcmProjectNumb(Context context) {
        String gcmSenderNumber = "";
        gcmSenderNumber = UtilsBucksTracks.getMetaData(context, "GcmSender");
        return gcmSenderNumber;
    }

    public static String getMetadataAppId(Context context) {
        String appId = "";
        appId = UtilsBucksTracks.getMetaData(context, "TatsAppId");
        return appId;
    }

    public static String getMetadataLogLevel(Context context) {
        String logLevel = "";
        logLevel = UtilsBucksTracks.getMetaData(context, "TatsLogLevel");
        return logLevel;
    }

    public static String getMetadataEnviroment(Context context) {
        String env = "";
        env = UtilsBucksTracks.getMetaData(context, "TatsEnvironment");
        return env;
    }

    public static boolean isExistService() {
        return false;
    }
}

