/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.async;

import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.DaoLog;
import de.greenrobot.dao.async.AsyncOperation;
import de.greenrobot.dao.async.AsyncOperationListener;
import de.greenrobot.dao.query.Query;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class AsyncOperationExecutor
implements Runnable,
Handler.Callback {
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private final BlockingQueue<AsyncOperation> queue = new LinkedBlockingQueue<AsyncOperation>();
    private volatile boolean executorRunning;
    private volatile int maxOperationCountToMerge = 50;
    private volatile AsyncOperationListener listener;
    private volatile AsyncOperationListener listenerMainThread;
    private volatile int waitForMergeMillis = 50;
    private int countOperationsEnqueued;
    private int countOperationsCompleted;
    private Handler handlerMainThread;
    private int lastSequenceNumber;

    AsyncOperationExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(AsyncOperation operation) {
        AsyncOperationExecutor asyncOperationExecutor = this;
        synchronized (asyncOperationExecutor) {
            operation.sequenceNumber = ++this.lastSequenceNumber;
            this.queue.add(operation);
            ++this.countOperationsEnqueued;
            if (!this.executorRunning) {
                this.executorRunning = true;
                executorService.execute(this);
            }
        }
    }

    public int getMaxOperationCountToMerge() {
        return this.maxOperationCountToMerge;
    }

    public void setMaxOperationCountToMerge(int maxOperationCountToMerge) {
        this.maxOperationCountToMerge = maxOperationCountToMerge;
    }

    public int getWaitForMergeMillis() {
        return this.waitForMergeMillis;
    }

    public void setWaitForMergeMillis(int waitForMergeMillis) {
        this.waitForMergeMillis = waitForMergeMillis;
    }

    public AsyncOperationListener getListener() {
        return this.listener;
    }

    public void setListener(AsyncOperationListener listener) {
        this.listener = listener;
    }

    public AsyncOperationListener getListenerMainThread() {
        return this.listenerMainThread;
    }

    public void setListenerMainThread(AsyncOperationListener listenerMainThread) {
        this.listenerMainThread = listenerMainThread;
    }

    public synchronized boolean isCompleted() {
        return this.countOperationsEnqueued == this.countOperationsCompleted;
    }

    public synchronized void waitForCompletion() {
        while (!this.isCompleted()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new DaoException("Interrupted while waiting for all operations to complete", e);
            }
        }
    }

    public synchronized boolean waitForCompletion(int maxMillis) {
        if (!this.isCompleted()) {
            try {
                this.wait(maxMillis);
            }
            catch (InterruptedException e) {
                throw new DaoException("Interrupted while waiting for all operations to complete", e);
            }
        }
        return this.isCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                if ((operation = this.queue.poll(1L, TimeUnit.SECONDS)) != null) ** GOTO lbl13
                var2_3 = this;
                // MONITORENTER : var2_3
                operation = (AsyncOperation)this.queue.poll();
                if (operation == null) {
                    this.executorRunning = false;
                    // MONITOREXIT : var2_3
                    return;
                }
                // MONITOREXIT : var2_3
lbl13:
                // 2 sources

                if (operation == null) continue;
                if (operation.isMergeTx() && (operation2 = this.queue.poll(this.waitForMergeMillis, TimeUnit.MILLISECONDS)) != null) {
                    if (operation.isMergeableWith(operation2)) {
                        this.mergeTxAndExecute(operation, operation2);
                        continue;
                    }
                    this.executeOperationAndPostCompleted(operation);
                    this.executeOperationAndPostCompleted(operation2);
                    continue;
                }
                this.executeOperationAndPostCompleted(operation);
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            DaoLog.w(Thread.currentThread().getName() + " was interruppted", e);
            return;
        }
        finally {
            this.executorRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeTxAndExecute(AsyncOperation operation1, AsyncOperation operation2) {
        ArrayList<AsyncOperation> mergedOps = new ArrayList<AsyncOperation>();
        mergedOps.add(operation1);
        mergedOps.add(operation2);
        SQLiteDatabase db = operation1.getDatabase();
        db.beginTransaction();
        boolean failed = false;
        try {
            for (int i = 0; i < mergedOps.size(); ++i) {
                AsyncOperation operation = (AsyncOperation)mergedOps.get(i);
                this.executeOperation(operation);
                if (operation.isFailed()) {
                    failed = true;
                    break;
                }
                if (i != mergedOps.size() - 1) continue;
                AsyncOperation peekedOp = (AsyncOperation)this.queue.peek();
                if (i < this.maxOperationCountToMerge && operation.isMergeableWith(peekedOp)) {
                    AsyncOperation removedOp = (AsyncOperation)this.queue.remove();
                    if (removedOp != peekedOp) {
                        throw new DaoException("Internal error: peeked op did not match removed op");
                    }
                    mergedOps.add(removedOp);
                    continue;
                }
                db.setTransactionSuccessful();
            }
        }
        finally {
            db.endTransaction();
        }
        if (failed) {
            DaoLog.i("Revered merged transaction because one of the operations failed. Executing operations one by one instead...");
            for (AsyncOperation asyncOperation : mergedOps) {
                asyncOperation.reset();
                this.executeOperationAndPostCompleted(asyncOperation);
            }
        } else {
            int mergedCount = mergedOps.size();
            for (AsyncOperation asyncOperation : mergedOps) {
                asyncOperation.mergedOperationsCount = mergedCount;
                this.handleOperationCompleted(asyncOperation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOperationCompleted(AsyncOperation operation) {
        operation.setCompleted();
        AsyncOperationListener listenerToCall = this.listener;
        if (listenerToCall != null) {
            listenerToCall.onAsyncOperationCompleted(operation);
        }
        if (this.listenerMainThread != null) {
            if (this.handlerMainThread == null) {
                this.handlerMainThread = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
            }
            Message msg = this.handlerMainThread.obtainMessage(1, (Object)operation);
            this.handlerMainThread.sendMessage(msg);
        }
        AsyncOperationExecutor asyncOperationExecutor = this;
        synchronized (asyncOperationExecutor) {
            ++this.countOperationsCompleted;
            if (this.countOperationsCompleted == this.countOperationsEnqueued) {
                this.notifyAll();
            }
        }
    }

    private void executeOperationAndPostCompleted(AsyncOperation operation) {
        this.executeOperation(operation);
        this.handleOperationCompleted(operation);
    }

    private void executeOperation(AsyncOperation operation) {
        operation.timeStarted = System.currentTimeMillis();
        try {
            switch (operation.type) {
                case Delete: {
                    operation.dao.delete(operation.parameter);
                    break;
                }
                case DeleteInTxIterable: {
                    operation.dao.deleteInTx((Iterable)operation.parameter);
                    break;
                }
                case DeleteInTxArray: {
                    operation.dao.deleteInTx((Object[])((Object[])operation.parameter));
                    break;
                }
                case Insert: {
                    operation.dao.insert(operation.parameter);
                    break;
                }
                case InsertInTxIterable: {
                    operation.dao.insertInTx((Iterable)operation.parameter);
                    break;
                }
                case InsertInTxArray: {
                    operation.dao.insertInTx((Object[])((Object[])operation.parameter));
                    break;
                }
                case InsertOrReplace: {
                    operation.dao.insertOrReplace(operation.parameter);
                    break;
                }
                case InsertOrReplaceInTxIterable: {
                    operation.dao.insertOrReplaceInTx((Iterable)operation.parameter);
                    break;
                }
                case InsertOrReplaceInTxArray: {
                    operation.dao.insertOrReplaceInTx((Object[])((Object[])operation.parameter));
                    break;
                }
                case Update: {
                    operation.dao.update(operation.parameter);
                    break;
                }
                case UpdateInTxIterable: {
                    operation.dao.updateInTx((Iterable)operation.parameter);
                    break;
                }
                case UpdateInTxArray: {
                    operation.dao.updateInTx((Object[])((Object[])operation.parameter));
                    break;
                }
                case TransactionRunnable: {
                    this.executeTransactionRunnable(operation);
                    break;
                }
                case TransactionCallable: {
                    this.executeTransactionCallable(operation);
                    break;
                }
                case QueryList: {
                    operation.result = ((Query)operation.parameter).list();
                    break;
                }
                case QueryUnique: {
                    operation.result = ((Query)operation.parameter).unique();
                    break;
                }
                case DeleteByKey: {
                    operation.dao.deleteByKey(operation.parameter);
                    break;
                }
                case DeleteAll: {
                    operation.dao.deleteAll();
                    break;
                }
                case Load: {
                    operation.result = operation.dao.load(operation.parameter);
                    break;
                }
                case LoadAll: {
                    operation.result = operation.dao.loadAll();
                    break;
                }
                case Count: {
                    operation.result = operation.dao.count();
                    break;
                }
                case Refresh: {
                    operation.dao.refresh(operation.parameter);
                    break;
                }
                default: {
                    throw new DaoException("Unsupported operation: " + (Object)((Object)operation.type));
                }
            }
        }
        catch (Throwable th) {
            operation.throwable = th;
        }
        operation.timeCompleted = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTransactionRunnable(AsyncOperation operation) {
        SQLiteDatabase db = operation.getDatabase();
        db.beginTransaction();
        try {
            ((Runnable)operation.parameter).run();
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTransactionCallable(AsyncOperation operation) throws Exception {
        SQLiteDatabase db = operation.getDatabase();
        db.beginTransaction();
        try {
            operation.result = ((Callable)operation.parameter).call();
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    public boolean handleMessage(Message msg) {
        AsyncOperationListener listenerToCall = this.listenerMainThread;
        if (listenerToCall != null) {
            listenerToCall.onAsyncOperationCompleted((AsyncOperation)msg.obj);
        }
        return false;
    }
}

