/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.query.AbstractQuery;

public class CountQuery<T>
extends AbstractQuery<T> {
    private final ThreadLocalQuery<T> threadLocalQuery;

    static <T2> CountQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        ThreadLocalQuery threadLocal = new ThreadLocalQuery(dao, sql, CountQuery.toStringArray(initialValues));
        return (CountQuery)threadLocal.get();
    }

    private CountQuery(ThreadLocalQuery<T> threadLocalQuery, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, sql, initialValues);
        this.threadLocalQuery = threadLocalQuery;
    }

    public CountQuery<T> forCurrentThread() {
        CountQuery query = (CountQuery)this.threadLocalQuery.get();
        String[] initialValues = ((ThreadLocalQuery)this.threadLocalQuery).initialValues;
        System.arraycopy(initialValues, 0, query.parameters, 0, initialValues.length);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        try {
            if (!cursor.moveToNext()) {
                throw new DaoException("No result for count");
            }
            if (!cursor.isLast()) {
                throw new DaoException("Unexpected row count: " + cursor.getCount());
            }
            if (cursor.getColumnCount() != 1) {
                throw new DaoException("Unexpected column count: " + cursor.getColumnCount());
            }
            long l = cursor.getLong(0);
            return l;
        }
        finally {
            cursor.close();
        }
    }

    private static final class ThreadLocalQuery<T2>
    extends ThreadLocal<CountQuery<T2>> {
        private final String sql;
        private final AbstractDao<T2, ?> dao;
        private final String[] initialValues;

        private ThreadLocalQuery(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            this.dao = dao;
            this.sql = sql;
            this.initialValues = initialValues;
        }

        @Override
        protected CountQuery<T2> initialValue() {
            return new CountQuery(this, this.dao, this.sql, (String[])this.initialValues.clone());
        }
    }
}

