/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.query.AbstractQuery;

public class DeleteQuery<T>
extends AbstractQuery<T> {
    private SQLiteStatement compiledStatement;
    private final ThreadLocalQuery<T> threadLocalQuery;

    static <T2> DeleteQuery<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        ThreadLocalQuery threadLocal = new ThreadLocalQuery(dao, sql, DeleteQuery.toStringArray(initialValues));
        return (DeleteQuery)threadLocal.get();
    }

    private DeleteQuery(ThreadLocalQuery<T> threadLocalQuery, AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        super(dao, sql, initialValues);
        this.threadLocalQuery = threadLocalQuery;
    }

    public DeleteQuery<T> forCurrentThread() {
        DeleteQuery query = (DeleteQuery)this.threadLocalQuery.get();
        String[] initialValues = ((ThreadLocalQuery)this.threadLocalQuery).initialValues;
        System.arraycopy(initialValues, 0, query.parameters, 0, initialValues.length);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDeleteWithoutDetachingEntities() {
        this.checkThread();
        SQLiteDatabase db = this.dao.getDatabase();
        if (db.isDbLockedByCurrentThread()) {
            this.executeDeleteWithoutDetachingEntitiesInsideTx();
        } else {
            db.beginTransaction();
            try {
                this.executeDeleteWithoutDetachingEntitiesInsideTx();
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
    }

    private synchronized void executeDeleteWithoutDetachingEntitiesInsideTx() {
        if (this.compiledStatement != null) {
            this.compiledStatement.clearBindings();
        } else {
            this.compiledStatement = this.dao.getDatabase().compileStatement(this.sql);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            String value = this.parameters[i];
            if (value != null) {
                this.compiledStatement.bindString(i + 1, value);
                continue;
            }
            this.compiledStatement.bindNull(i + 1);
        }
        this.compiledStatement.execute();
    }

    private static final class ThreadLocalQuery<T2>
    extends ThreadLocal<DeleteQuery<T2>> {
        private final String sql;
        private final AbstractDao<T2, ?> dao;
        private final String[] initialValues;

        private ThreadLocalQuery(AbstractDao<T2, ?> dao, String sql, String[] initialValues) {
            this.dao = dao;
            this.sql = sql;
            this.initialValues = initialValues;
        }

        @Override
        protected DeleteQuery<T2> initialValue() {
            return new DeleteQuery(this, this.dao, this.sql, (String[])this.initialValues.clone());
        }
    }
}

