/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.query.AbstractQuery;
import de.greenrobot.dao.query.CloseableListIterator;
import de.greenrobot.dao.query.LazyList;
import java.util.List;

public class Query<T>
extends AbstractQuery<T> {
    private final int limitPosition;
    private final int offsetPosition;
    private final ThreadLocalQuery<T> threadLocalQuery;

    public static <T2> Query<T2> internalCreate(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        return Query.create(dao, sql, initialValues, -1, -1);
    }

    static <T2> Query<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues, int limitPosition, int offsetPosition) {
        ThreadLocalQuery threadLocal = new ThreadLocalQuery(dao, sql, Query.toStringArray(initialValues), limitPosition, offsetPosition);
        return (Query)threadLocal.get();
    }

    private Query(ThreadLocalQuery<T> threadLocalQuery, AbstractDao<T, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
        super(dao, sql, initialValues);
        this.threadLocalQuery = threadLocalQuery;
        this.limitPosition = limitPosition;
        this.offsetPosition = offsetPosition;
    }

    public Query<T> forCurrentThread() {
        Query query = (Query)this.threadLocalQuery.get();
        String[] initialValues = ((ThreadLocalQuery)this.threadLocalQuery).initialValues;
        System.arraycopy(initialValues, 0, query.parameters, 0, initialValues.length);
        return query;
    }

    @Override
    public void setParameter(int index, Object parameter) {
        if (index >= 0 && (index == this.limitPosition || index == this.offsetPosition)) {
            throw new IllegalArgumentException("Illegal parameter index: " + index);
        }
        super.setParameter(index, parameter);
    }

    public void setLimit(int limit) {
        this.checkThread();
        if (this.limitPosition == -1) {
            throw new IllegalStateException("Limit must be set with QueryBuilder before it can be used here");
        }
        this.parameters[this.limitPosition] = Integer.toString(limit);
    }

    public void setOffset(int offset) {
        this.checkThread();
        if (this.offsetPosition == -1) {
            throw new IllegalStateException("Offset must be set with QueryBuilder before it can be used here");
        }
        this.parameters[this.offsetPosition] = Integer.toString(offset);
    }

    public List<T> list() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return this.daoAccess.loadAllAndCloseCursor(cursor);
    }

    public LazyList<T> listLazy() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return new LazyList(this.daoAccess, cursor, true);
    }

    public LazyList<T> listLazyUncached() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return new LazyList(this.daoAccess, cursor, false);
    }

    public CloseableListIterator<T> listIterator() {
        return this.listLazyUncached().listIteratorAutoClose();
    }

    public T unique() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return this.daoAccess.loadUniqueAndCloseCursor(cursor);
    }

    public T uniqueOrThrow() {
        T entity = this.unique();
        if (entity == null) {
            throw new DaoException("No entity found for query");
        }
        return entity;
    }

    private static final class ThreadLocalQuery<T2>
    extends ThreadLocal<Query<T2>> {
        private final String sql;
        private final AbstractDao<T2, ?> dao;
        private final String[] initialValues;
        private final int limitPosition;
        private final int offsetPosition;

        private ThreadLocalQuery(AbstractDao<T2, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
            this.dao = dao;
            this.sql = sql;
            this.initialValues = initialValues;
            this.limitPosition = limitPosition;
            this.offsetPosition = offsetPosition;
        }

        @Override
        protected Query<T2> initialValue() {
            return new Query(this, this.dao, this.sql, (String[])this.initialValues.clone(), this.limitPosition, this.offsetPosition);
        }
    }
}

