/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.test;

import android.app.Application;
import android.database.sqlite.SQLiteDatabase;
import android.test.ApplicationTestCase;
import de.greenrobot.dao.DbUtils;
import java.util.Random;

public abstract class DbTest<T extends Application>
extends ApplicationTestCase<T> {
    protected SQLiteDatabase db;
    protected Random random;
    protected final boolean inMemory;

    public DbTest() {
        this(true);
    }

    public DbTest(boolean inMemory) {
        this(Application.class, inMemory);
    }

    public DbTest(Class<T> appClass, boolean inMemory) {
        super(appClass);
        this.inMemory = inMemory;
        this.random = new Random();
    }

    protected void setUp() {
        try {
            super.setUp();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.createApplication();
        this.setUpDb();
    }

    protected void setUpDb() {
        if (this.inMemory) {
            this.db = SQLiteDatabase.create(null);
        } else {
            this.getApplication().deleteDatabase("test-db");
            this.db = this.getApplication().openOrCreateDatabase("test-db", 0, null);
        }
    }

    protected void tearDown() throws Exception {
        this.db.close();
        if (!this.inMemory) {
            this.getApplication().deleteDatabase("test-db");
        }
        super.tearDown();
    }

    protected void logTableDump(String tablename) {
        DbUtils.logTableDump(this.db, tablename);
    }
}

