package com.tatssense.sampleapp;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.tatssense.core.Buckstracks;
import com.tatssense.core.util.BuildBuckstracks;


public class MainActivity extends Activity {


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main_new);

        ((TextView)findViewById(R.id.version)).setText(BuildBuckstracks.VERSION + " - " + BuildBuckstracks.VERSION_CODE);

	}

    @Override
    protected void onRestart() {
        super.onRestart();
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void appTracker(View view){

		switch (view.getId()) {
		case R.id.costruttore:
			Buckstracks.trackInst(this);
			break;
		case R.id.open:
			Buckstracks.trackOpen(this);
			break;
		case R.id.close:
			Buckstracks.trackClose(getApplicationContext());
			break;
		case R.id.gcm:
			Buckstracks.trackGcm(getApplicationContext());
			break;
		case R.id.update:
			Buckstracks.trackUpdate(getApplicationContext());
			break;
		case R.id.userId:
			Buckstracks.trackUserId(getApplicationContext());
			break;
		case R.id.customEvent:
			Buckstracks.trackCustomEvent("200", "value_custom_event",  getApplicationContext());
			break;
		case R.id.purchase:
			Buckstracks.trackPurchase("EUR", "70", getApplicationContext());
			break;

		default:
			break;
		}

	}


}
