//
//  AppTracker.h
//  AcoSdkTracker v1.3.2
//
//  Created by Serafino Solreti on 24/01/14.
//  Copyright (c) 2014 Acotel S.P.A. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol AppTrackerDelegate

- (void)AppTrackerDelegate_ReceivedPushId: (NSString *)devicePushId;

@end

@interface AppTracker : NSObject

+ (AppTracker *)sharedInstance;

//Call one of these methods below before to use any track methods
- (void)startWithAdvertiserId:(NSString *)advertiserId;
- (void)startWithAdvertiserId:(NSString *)advertiserId andDelegate: (NSObject<AppTrackerDelegate> *)del;
- (void)startWithAdvertiserId:(NSString *)advertiserId andGcmId:(NSString *)gcmId;
- (void)startWithAdvertiserId:(NSString *)advertiserId andGcmId:(NSString *)gcmId andDelegate: (NSObject<AppTrackerDelegate> *)del;

//Calling any of the track methods after calling this led to assertion failure.
//Tracking methods cannot be called after calling the method below
- (void)stop;

//App installation tracking: call it into applicationDidFinishLaunching/applicationDidFinishLaunchingWithOptions
- (void)trackInstall;

//App launch tracking
- (void)trackOpen;
//App launch tracking (checks notification payload): call it into applicationDidFinishLaunchingWithOptions
- (void)trackOpen: (NSDictionary *)launchOptionsDict;

//Push Notification Click
- (void)trackNotificationClick: (NSDictionary *)payloadDict;

//App quit event tracking: call it into applicationWillTerminate (remember that applicationWillTerminate could be never called
//if multitasking is enabled for your app. Multitasking is enabled by default for iOS app )
- (void)trackClose;

//In App purchase item/subscription tracking.
//USE CASE: user click on your app custom purchase button
//          and you call the method below into the method
//          connected to button click.
- (void)trackSubscription;
//USE CASE: user does an in-app purchase and you call the method below to track revenues.
- (void)trackPurchasePrice: (NSDecimalNumber *)price withCurrency: (NSString *)currencyCode;

//Device token tracking: call it whenever the device token is provided to app
- (void)handleAppRegisteredForRemoteNotificationWithToken: (NSData *)deviceToken;

//For tracking an event related to another <NAME???> SDK.
- (void)trackUserId;

//Custom app event tracking
//call it with the custom eventId already registered on SDK back end for your app.
- (void)eventTrackerWithId: (NSString*)eventId;
//call it with the custom eventId, already registered on SDK back end for your app, and the custom value
- (void)trackCustomEvent: (NSString *)customEventId withValue: (NSString *)customValue;

@end
